// ***********************************************************************
//
// List implementation of a Queue
//
// ***********************************************************************
// Computer Science 102: Data Structures
// New York University, Fall 2013,
//
// Lecturers: Eric Koskinen and Daniel Schwartz-Narbonne
//
// ***********************************************************************

public class QueueList<E> implements Queue<E> {

	// Represent the Queue as a List using the generic MyList<E>
	private MyList<E> queue;

	public QueueList() {
		queue = new MyList<E>();
	}

	// Basic operations
	public int size() {
//		return queue.size();
		if (queue.firstNode.next == null)
			return 0;
		else
			return queue.size();
	}

	public boolean isEmpty() {
		return queue.isEmpty();
	}

	// The Enqueue() operation inserts at the front of the list
	public void enqueue(E element) {
		queue.insertFront(element);
	}

	// The Dequeue() operation removes from the back of the list
	// (and throws an exception if the list is empty)
	public E dequeue() throws InvalidOperationException {
		if (!queue.isEmpty()) {
			return queue.removeBack();
		} else {
			throw new InvalidOperationException(
					"Queue empty: nothing to dequeue.");
		}
	}

	// Output operations
	public String toString() {
		return "IN -> " + queue.toString() + " -> OUT";
	}

	public void PrettyPrint() {
		System.out.println(toString());
	}
}